<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('usuario_model');
    }

    function index() {
        if ($this->session->userdata("validado")) {
            redirect('principal');
        } else {
            $data['content'] = 'login';
            $this->load->view('template_login', $data);
        }
    }

    public function validar_usuario() {
        $usuario = $this->input->post('username');
        $password = $this->input->post('password');
        $usuario_valido = $this->usuario_model->validar_usuario($usuario,$password);
        if ($usuario_valido == 0) {
            $this->session->set_flashdata("mensaje","Usuario no registrado");
            redirect(base_url());
        } else {
           $cod_ipres = "";
            $nom_ipres = "";
            $cod_red = "";
            $nom_red = "";
            $tipo_alm = "";
            $tipo_iprres = "";
            $buscar_usuario = $this->usuario_model->buscar_usuario($usuario);
            for ($i = 0; $i < count($buscar_usuario); $i++) {
                $cod_ipres = $buscar_usuario[$i]['cod_ipres'];
                $nom_ipres = $buscar_usuario[$i]['nom_ipres'];
                $cod_red = $buscar_usuario[$i]['cod_red'];
                $nom_red = $buscar_usuario[$i]['nom_red'];
                $tipo_alm = $buscar_usuario[$i]['tipo_alm'];
                $tipo_iprres = $buscar_usuario[$i]['tipo_iprres'];
            }
            $data = array(
                'usuario' => $usuario,
                'cod_ipres' => $cod_ipres,
                'nom_ipres' => $nom_ipres,
                'cod_red' => $cod_red,
                'nom_red' => $nom_red,
                'tipo_alm' => $tipo_alm,
                'tipo_iprres' => $tipo_iprres,
                'validado' => TRUE
            );
            $this->session->set_userdata($data);
            redirect('principal');
        }
       
    }

    public function cerrar_sesion() {
        $this->session->sess_destroy();
        redirect(base_url());
    }

}
