<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Principal extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('bimestre_model');
        $this->load->model('usuario_model');
        $this->load->model('unidades_model');
        $this->load->model('grado_model');
        $this->load->model('contenido_model');
        $this->load->model('plan_model');
        $this->load->model('personal_model');
    }

    function index() {
        if ($this->session->userdata("validado")) {

            $idusuario = $this->session->userdata("usuario");
            $list_max = $this->bimestre_model->max_fecha_reg($idusuario);
            $fecha_max = '';
            for ($i = 0; $i < count($list_max); $i++) {
                $fecha_max = $list_max[$i]['fecha_max'];
            }
            $cod_red = $this->session->userdata("cod_red");
            if ($cod_red == '9') {
                //$list_unidades = $this->bimestre_model->list_prod_reg($idusuario, $fecha_max);
                $data['content'] = 'contenido5';
                $data["fecha_max"] = $fecha_max;
                //$data['list_unidades'] = $list_unidades;
                $this->load->view('template', $data);
            } else if ($cod_red == '10') {
                $cod_red = substr($idusuario, -1);
                $list_max_red = $this->bimestre_model->max_fecha_reg_red($cod_red);
                $fecha_max_red = '';
                for ($i = 0; $i < count($list_max_red); $i++) {
                    $fecha_max_red = $list_max_red[$i]['fecha_max'];
                }
                $list_ipress_total = $this->bimestre_model->cant_ipress_total($cod_red);
                $list_ipress_reg = $this->bimestre_model->cant_ipress_reg($cod_red, 0);
                $list_all_epp = $this->bimestre_model->list_all_epp($cod_red, $fecha_max_red);

                $data['content'] = 'contenido4';
                $data["fecha_max"] = $fecha_max_red;
                $data['list_unidades'] = $list_all_epp;
                $data["list_ipress_total"] = $list_ipress_total;
                $data["list_ipress_reg"] = $list_ipress_reg;
                $this->load->view('template', $data);
            } else {
                $list_unidades = $this->bimestre_model->list_prod_reg($idusuario, $fecha_max);
                $data['content'] = 'contenido';
                $data["fecha_max"] = $fecha_max;
                $data['list_unidades'] = $list_unidades;
                $this->load->view('template', $data);
            }
        } else {
            $data['content'] = 'login';
            $this->load->view('template_login', $data);
        }
    }

    function list_unid_aprendizaje() {
        $idusuario = $this->session->userdata("cod_ipres");
        $list_unidades = $this->bimestre_model->list_bimetres2($idusuario);
        $data['content'] = 'lista_unidades';
        $data['list_unidades'] = $list_unidades;
        $this->load->view('template', $data);
    }

    function view_unid_aprendizaje() {
        $list_grados = $this->grado_model->list_grados();
        $data['content'] = 'form_reg_unidad';
        $data['list_grados'] = $list_grados;
        $this->load->view('template', $data);
    }

    function reg_unid_aprendizaje() {
        $cod_ipres = $this->session->userdata("cod_ipres");
        $stock = $_POST['stock'];
        $cbproducto = $_POST['cbproducto'];

        $list_fech_actual = $this->bimestre_model->fecha_actual();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }

        $prod_reg = $this->bimestre_model->validad_registro($cod_ipres, $cbproducto, $fech_actual);
        $row = count($prod_reg);
        if ($row > 0) {
            //echo 'El stock del producto se encunetra actualizado';
            $this->session->set_flashdata("mensaje", "El stock del producto se encunetra actualizado");
            redirect('principal/view_unid_aprendizaje');
        } else {
            $data = array(
                'cod_med' => $cbproducto,
                'stock' => $stock,
                'cod_ipres' => $cod_ipres
            );
            //echo 'bien';
            $this->unidades_model->add_unidadad($data);
            redirect('principal/list_unid_aprendizaje');
        }
    }

    function act_unid_aprendizaje() {
        $id_det = $_REQUEST['id_det'];
        $list_detalle = $this->bimestre_model->buscar_dettalle($id_det);
        $cod_med = '';
        $nom_med = '';
        $stock = 0;
        for ($i = 0; $i < count($list_detalle); $i++) {
            $cod_med = $list_detalle[$i]['cod_med'];
            $nom_med = $list_detalle[$i]['nom_med'];
            $stock = $list_detalle[$i]['stock'];
        }

        $data['content'] = 'form_act_unidad';
        $data['id_det'] = $id_det;
        $data['cod_med'] = $cod_med;
        $data['nom_med'] = $nom_med;
        $data['stock'] = $stock;
        $this->load->view('template', $data);
    }

    function act_reg_unid_aprendizaje() {
        $id_det = $_POST['id_det'];
        $cod_ipres = $this->session->userdata("cod_ipres");
        $cod_med = $_POST['cod_med'];
        $stock = $_POST['stock'];

        $data = array(
            'stock' => $stock
        );
        $this->bimestre_model->edit_detalle($data, $id_det);
        redirect('principal/list_unid_aprendizaje');
    }

    function list_all_plan_trabajo() {
        $idusuario = $this->session->userdata("usuario");
        $list_all_plan = $this->plan_model->list_all_plan_trabajo();
        $buscar_foto_perfil = $this->usuario_model->buscar_foto_perfil($idusuario);
        $data['content'] = 'lista_rev_plan_trabajo';
        $data['list_all_plan_trabajo'] = $list_all_plan;
        $data["buscar_foto_perfil"] = $buscar_foto_perfil;
        $this->load->view('template', $data);
    }

    function view_modal_plan_trabajo($id) {
        $data = array(
            'list_detalle_reg' => $this->bimestre_model->list_detalle_reg($id),
            'buscar_ipress' => $this->bimestre_model->buscar_ipress($id),
        );
        $this->load->view("modal/view_modal_plan_trabajo", $data);
    }

    function aprobar_plan_trabajo($id) {
        $data = array(
            'estado' => '1',
        );
        $this->plan_model->aprobar_plan_trabajo($data, $id);
        echo 'principal/list_all_plan_trabajo';
    }

    function list_all_uniades() {
        $idusuario = $this->session->userdata("usuario");
        $list_all_plan = $this->plan_model->list_all_plan_trabajo();
        $buscar_foto_perfil = $this->usuario_model->buscar_foto_perfil($idusuario);
        $list_bimestres = $this->bimestre_model->list_bimestre_estado();
        $list_personal = $this->personal_model->list_all_personal();
        $data['content'] = 'lista_rev_unidades';
        $data['list_all_plan_trabajo'] = $list_all_plan;
        $data["buscar_foto_perfil"] = $buscar_foto_perfil;
        $data['list_bimestres'] = $list_bimestres;
        $data['list_all_personal'] = $list_personal;
        $this->load->view('template', $data);
    }

    function view_grado($id) {
        $list_grado_personal = $this->personal_model->list_grado_personal($id);
        $data = array(
            'list_grado_personal' => $list_grado_personal,
        );
        $this->load->view("modal/view_grado", $data);
    }

    function view_list_ipress_reg() {
        $idusuario = $this->session->userdata("usuario");
        $list_max = $this->bimestre_model->max_fecha_reg($idusuario);
        $fecha_max = '';
        for ($i = 0; $i < count($list_max); $i++) {
            $fecha_max = $list_max[$i]['fecha_max'];
        }
        $dia_actual = date('d');
        $cod_red = substr($idusuario, -1);
        echo '' . $cod_red;
        $list_unidades = $this->bimestre_model->list_ipress_reg($cod_red, $dia_actual);
        $list_ipress_total = $this->bimestre_model->cant_ipress_total($cod_red);
        $list_ipress_reg = $this->bimestre_model->cant_ipress_reg($cod_red, 0);

        $data['content'] = 'contenido2';
        $data["fecha_max"] = $fecha_max;
        $data['list_unidades'] = $list_unidades;
        $data["list_ipress_total"] = $list_ipress_total;
        $data["list_ipress_reg"] = $list_ipress_reg;
        $this->load->view('template', $data);
    }

    function view_list_ipress_tot() {
        $idusuario = $this->session->userdata("usuario");
        $list_max = $this->bimestre_model->max_fecha_reg($idusuario);
        $fecha_max = '';
        for ($i = 0; $i < count($list_max); $i++) {
            $fecha_max = $list_max[$i]['fecha_max'];
        }
        $cod_red = substr($idusuario, -1);

        $list_unidades2 = $this->bimestre_model->list_ipress_reg_total($cod_red);
        $list_ipress_total = $this->bimestre_model->cant_ipress_total($cod_red);
        $list_ipress_reg = $this->bimestre_model->cant_ipress_reg($cod_red, 0);

        $data['content'] = 'contenido3';
        $data["fecha_max"] = $fecha_max;
        $data['list_unidades2'] = $list_unidades2;
        $data["list_ipress_total"] = $list_ipress_total;
        $data["list_ipress_reg"] = $list_ipress_reg;
        $this->load->view('template', $data);
    }

    function view_list_prod() {
        $idusuario = $this->session->userdata("cod_ipres");
        $list_unidades = $this->bimestre_model->list_prod_stock_ant($idusuario);
        $data['content'] = 'lista_prod_anterior';
        $data['list_unidades'] = $list_unidades;
        $this->load->view('template', $data);
    }

    function act_prod_reg_anterior() {
        $list_fech_actual = $this->bimestre_model->fecha_actual();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }
        $estado = false;
        $idusuario = $this->session->userdata("cod_ipres");
        $list_prod_stock_ant = $this->bimestre_model->list_prod_stock_ant($idusuario);
        $row = count($list_prod_stock_ant);
        if ($row == 0) {
            $this->session->set_flashdata("mensaje", "No cuenta con ningún registro de stock actualizado");
            redirect('principal/view_list_prod');
        } else {
            for ($i = 0; $i < count($list_prod_stock_ant); $i++) {
                $prod_reg = $this->bimestre_model->validad_registro($idusuario, $list_prod_stock_ant[$i]['cod_med'], $fech_actual);
                $row2 = count($prod_reg);
                if ($row2 > 0) {
                    $estado = true;
                } else {
                    $data = array(
                        'cod_med' => $list_prod_stock_ant[$i]['cod_med'],
                        'stock' => $list_prod_stock_ant[$i]['stock'],
                        'cod_ipres' => $idusuario
                    );
                    $this->unidades_model->add_unidadad($data);
                }
            }
            if ($estado == true) {
                $this->session->set_flashdata("mensaje", "El stock del producto se encunetra actualizado");
                redirect('principal/view_list_prod');
            }
            redirect('principal/list_unid_aprendizaje');
        }
    }

    function view_list_redes() {
        $id_red = $_REQUEST['cod_red'];
        //echo '' . $id_red . '<br>';
        $cod_red = substr($id_red, -1);
        //echo '' . $cod_red;
        $nom_ipress='';
        $lista_buscar_cod_ipress = $this->bimestre_model->buscar_cod_ipress($id_red);
        for ($i = 0; $i < count($lista_buscar_cod_ipress); $i++) {
            $nom_ipress = $lista_buscar_cod_ipress[$i]['nom_ipres'];
        }
        $list_max_red = $this->bimestre_model->max_fecha_reg_red($cod_red);
        $fecha_max_red = '';
        for ($i = 0; $i < count($list_max_red); $i++) {
            $fecha_max_red = $list_max_red[$i]['fecha_max'];
        }
        $list_all_epp = $this->bimestre_model->list_all_epp($cod_red, $fecha_max_red);

        $data['content'] = 'lista_epp_red';
        $data['list_unidades'] = $list_all_epp;
        $data['nom_ipress'] = $nom_ipress;
        $this->load->view('template', $data);
    }
    
    function wiew_list_subalmacen() {
        $id_red = $_REQUEST['cod_red'];
        $cod_red = substr($id_red, -1);
        $nom_ipress = '';
        $lista_buscar_cod_ipress = $this->bimestre_model->buscar_cod_ipress($id_red);
        for ($i = 0; $i < count($lista_buscar_cod_ipress); $i++) {
            $nom_ipress = $lista_buscar_cod_ipress[$i]['nom_ipres'];
        }
        $list_sub_almacen = $this->bimestre_model->list_subalmacen($cod_red);

        $data['content'] = 'lista_epp_subalmacen';
        $data['list_subalmacen'] = $list_sub_almacen;
        $data['nom_ipress'] = $nom_ipress;
        $this->load->view('template', $data);
    }
    
    function wiew_list_unid_ejecutora() {
        $id_red = $_REQUEST['cod_red'];
        $cod_red = substr($id_red, -1);
        $list_unid_ejecutoras = $this->bimestre_model->list_unid_ejecutoras($id_red);

        $data['content'] = 'lista_epp_unid_ejecutoras';
        $data['list_unid_ejecutoras'] = $list_unid_ejecutoras;
        $this->load->view('template', $data);
    }
    
    function view_list_all_ipress() {
        $id_red = $_REQUEST['cod_red'];
        $list_unid_ejecutoras = $this->bimestre_model->list_all_ipress($id_red);
        $list_red= $this->bimestre_model->list_red_byid($id_red);
        $nom_red = '';
        
        for ($i = 0; $i < count($list_red); $i++) {
            $nom_red = $list_red[$i]['nom_red'];
        }

        $data['content'] = 'lista_epp_all_ipress';
        $data['list_all_ipress'] = $list_unid_ejecutoras;
        $data['nom_red_id'] = $nom_red;
        $this->load->view('template', $data);
    }
    
    function view_report() {
        $list_fech_actual = $this->bimestre_model->fecha_actual2();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }
        $data['content'] = 'report_general';
        $data["fech_actual"] = $fech_actual;
        $this->load->view('template', $data);
    }

    function report_general_red() {
        $filename = 'report_general_red_salud';
        header("Pragma: public");
        header("Expies: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Content-Type application/force-download");
        header("Content-Type application/octet-stream");
        header("Content-Type application/download");
        header("Content-Type application/vnd.ms-excel;");
        header("Content-Disposition: attachment; filename=" . $filename . '.xls');
        print "\xEF\xBB\xBF"; // UTF-8 BOM
        //$fecha = '2020-05-29';
        $fecha = $_REQUEST['fecha'];
        $reporte_red_salud = $this->bimestre_model->reporte_red_salud($fecha);
        print'<h2><strong>REPORTE DE STOCK A DIARIO POR RED DE SALUD - HUANUCO <strong></h2>';
        print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
        print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
        print'<thead>';
        print'<tr>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED AMBO</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED HUANUCO</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED DOS DE MAYO</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED PUERTO INCA</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED PACHITEA</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED HUAMALIES</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RED LEONCIO PRADO</th>';
        print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Total general</th>';
        print'</tr>';
        print'</thead>';
        print '<tbody>';
        for ($i = 0; $i < count($reporte_red_salud); $i++) {
            print'<tr>';
            print'<td>' . ($i + 1) . '</td>';
            print'<td>' . $reporte_red_salud[$i]['cod_med'] . '</td>';
            print'<td>' . $reporte_red_salud[$i]['nom_med'] . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_ambo']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_huanuco']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_dos_mayo']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_puerto_inca']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_pachitea']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_huamalies']) . '</td>';
            print'<td align="center">' . number_format($reporte_red_salud[$i]['red_leoncio_prado']) . '</td>';
            $total = $reporte_red_salud[$i]['red_ambo']+$reporte_red_salud[$i]['red_huanuco']+$reporte_red_salud[$i]['red_dos_mayo']+$reporte_red_salud[$i]['red_puerto_inca']+$reporte_red_salud[$i]['red_pachitea']+$reporte_red_salud[$i]['red_huamalies']+$reporte_red_salud[$i]['red_leoncio_prado'];
            print'<td align="center">' . number_format($total) . '</td>';
            print'</tr>';
        }
        print '<tbody>';
        print'</table>';
    }
    
    function view_report_general() {
        $idusuario = $this->session->userdata("usuario");
        $list_max = $this->bimestre_model->max_fecha_reg($idusuario);
        $fecha_max = '';
        for ($i = 0; $i < count($list_max); $i++) {
            $fecha_max = $list_max[$i]['fecha_max'];
        }
        $cod_red = substr($idusuario, -1);
        $list_max_red = $this->bimestre_model->max_fecha_reg_red($cod_red);
        $fecha_max_red = '';
        for ($i = 0; $i < count($list_max_red); $i++) {
            $fecha_max_red = $list_max_red[$i]['fecha_max'];
        }
        
        $list_fech_actual = $this->bimestre_model->fecha_actual2();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }
        
        $list_ipress_total = $this->bimestre_model->cant_ipress_total($cod_red);
        $list_ipress_reg = $this->bimestre_model->cant_ipress_reg($cod_red, 0);
        $list_all_epp = $this->bimestre_model->list_all_epp($cod_red, $fecha_max_red);
        $data['content'] = 'contenido6';
        $data['list_unidades'] = $list_all_epp;
        $data["list_ipress_total"] = $list_ipress_total;
        $data["list_ipress_reg"] = $list_ipress_reg;
        $data["fech_actual"] = $fech_actual;
        $this->load->view('template', $data);
    }

    function report_excel() {
        //$fecha = '2020-05-29';
        $fecha = $_REQUEST['fecha'];
        $idusuario = $this->session->userdata("usuario");
        $cod_red = substr($idusuario, -1);
        if ($cod_red == '1') {
            $filename = 'red_salud_ambo';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '2') {
            $filename = 'red_salud_huanuco';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_red_huanuco = $this->bimestre_model->report_red_huanuco($fecha);
            print'<h2><strong>REPORTE DE STOCK A DIARIO - RED HUANUCO <strong></h2>';
            print'<h4><strong>FECHA : '.$fecha.' <strong></h4>';
            print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
            print'<thead>';
            print'<tr>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >ACOMAYO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">APARICIO POMARES</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CARLOS SHOWING FERRARI - F02</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CARLOS SHOWING FERRARI - MAT. INFANTIL</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CAYRAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CENTRO DE SALUD AMARILIS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CENTRO DE SALUD MENTAL COMUNITARIO PAK</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHAULAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHINCHINGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHULLAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHURUBAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COLPA BAJA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUACORA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUALLMISH</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANACAURE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCACHUPAC</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCAPALLAC</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCHAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">INGENIO BAJO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">JESUS DE NAZARETH DE COCHAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LA ESPERANZA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LAS MORAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LLACSA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MANANTIAL DE VIDA DE QUECHUALOMA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MARGOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NAUYAN RONDOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PACAYHUA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PAMPAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PAUCAR</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PERU-COREA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PILLAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">POMACUCHO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">POTRACANCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUEBLO LIBRE DE MAYOBAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD DE LLICUA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD DE PACHABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD MALCONGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCO DE LLAMAPASHILLUM</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCOS DE COCHABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN ISIDRO DE PAURA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JOSE DE COZO TINGO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JUAN DE LIBERTAD</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN MIGUEL DE MITOQUERA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE CANI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE CHOQUECANCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE PILLAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN SEBASTIAN DE QUERA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA CRUZ DE RATACOCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ISABEL</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA MARIA DEL VALLE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA DE SIRABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTIAGO DE LLACON</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTO TORIBIO DE MOGROVEJO DE ARAYPAGU</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAMBO DE SAN JOSE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAMBOGAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAPRAG</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TRES DE MAYO DE ANDAS CHICO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TRES DE MAYO DE PAGSHAG</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">UTAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YACUS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YARUMAYO</th>';
            print'</tr>';
            print'</thead>';
            print '<tbody>';
            for ($i = 0; $i < count($report_red_huanuco); $i++) {
                print'<tr>';
                print'<td>' . ($i + 1) . '</td>';
                print'<td>' . $report_red_huanuco[$i]['cod_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['nom_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['a'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['b'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['c'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['d'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['e'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['f'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['g'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['h'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['i'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['j'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['k'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['l'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['m'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['n'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['o'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['p'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['q'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['s'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['t'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['u'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['v'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['w'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['xx'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['yy'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['z'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aa'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ab'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ac'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ad'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ae'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['af'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ag'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ah'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ai'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aj'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ak'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['al'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['am'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['an'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ao'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ap'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aq'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ar'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ass'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['att'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['au'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['av'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aw'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ax'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ay'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['az'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ba'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bb'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bc'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bd'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['be'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bf'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bg'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bh'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bi'] . '</td>';
                print'</tr>';
            }
            print '<tbody>';
            print'</table>';
        } else if ($cod_red == '3') {
            $filename = 'red_salud_dos_mayo';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '4') {
            $filename = 'red_puerto_inca';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '5') {
            $filename = 'red_pachitea';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            
            $report_red_huanuco = $this->bimestre_model->report_red_pachitea($fecha);
            print'<h2><strong>REPORTE DE STOCK A DIARIO - RED PACHITEA <strong></h2>';
            print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
            print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
            print'<thead>';
            print'<tr>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >CHAGLLA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >CHINCHAYCOCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >GOYAR PUNTA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUACACHI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUARAPATAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUARICHACA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >JILLAULLA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MANZANO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MOLINOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MONTEHUASI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MUÑA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PAMPAMARCA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PANAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PINQUIRAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PUCAJAGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PUESTO DE SALUD HUANIN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >SAN MARCOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >SANTO TORIBIO DE LA PUNTA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TAMBILLO-UMARI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TAYAGASHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TOMAYRICA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >USHUMAYO</th>';
            print'</tr>';
            print'</thead>';
            print '<tbody>';
            for ($i = 0; $i < count($report_red_huanuco); $i++) {
                print'<tr>';
                print'<td>' . ($i + 1) . '</td>';
                print'<td>' . $report_red_huanuco[$i]['cod_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['nom_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['a'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['b'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['c'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['d'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['e'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['f'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['g'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['h'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['i'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['j'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['k'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['l'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['m'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['n'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['o'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['p'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['q'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['s'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['t'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['u'] . '</td>';
                print'</tr>';
            }
            print '<tbody>';
            print'</table>';
            
            
        } else if ($cod_red == '6') {
            $filename = 'red_huamalies';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '7') {
            $filename = 'red_leoncio_prado';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        }
    }
    
    function view_report_especifico() {
        $idusuario = $this->session->userdata("usuario");
        $list_max = $this->bimestre_model->max_fecha_reg($idusuario);
        $fecha_max = '';
        for ($i = 0; $i < count($list_max); $i++) {
            $fecha_max = $list_max[$i]['fecha_max'];
        }
        $cod_red = substr($idusuario, -1);
        $list_max_red = $this->bimestre_model->max_fecha_reg_red($cod_red);
        $fecha_max_red = '';
        for ($i = 0; $i < count($list_max_red); $i++) {
            $fecha_max_red = $list_max_red[$i]['fecha_max'];
        }

        $list_fech_actual = $this->bimestre_model->fecha_actual2();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }

        $list_red_salud = $this->bimestre_model->list_red_salud();
        $list_ipress_total = $this->bimestre_model->cant_ipress_total($cod_red);
        $list_ipress_reg = $this->bimestre_model->cant_ipress_reg($cod_red, 0);
        $list_all_epp = $this->bimestre_model->list_all_epp($cod_red, $fecha_max_red);
        $data['content'] = 'report_especifico_red';
        $data['list_unidades'] = $list_all_epp;
        $data["list_ipress_total"] = $list_ipress_total;
        $data["list_ipress_reg"] = $list_ipress_reg;
        $data["fech_actual"] = $fech_actual;
        $data["list_red_salud"] = $list_red_salud;
        $this->load->view('template', $data);
    }
    
    function report_excel_especifico() {
        //$fecha = '2020-05-29';
        $fecha = $_REQUEST['fecha'];
        $cbred = $_REQUEST['cbred'];
        $cod_red = substr($cbred, -1);

        if ($cod_red == '1') {
            $filename = 'red_salud_ambo';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '2') {
            $filename = 'red_salud_huanuco';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_red_huanuco = $this->bimestre_model->report_red_huanuco($fecha);
            print'<h2><strong>REPORTE DE STOCK A DIARIO - RED HUANUCO <strong></h2>';
            print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
            print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
            print'<thead>';
            print'<tr>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >ACOMAYO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">APARICIO POMARES</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CARLOS SHOWING FERRARI - F02</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CARLOS SHOWING FERRARI - MAT. INFANTIL</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CAYRAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CENTRO DE SALUD AMARILIS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CENTRO DE SALUD MENTAL COMUNITARIO PAK</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHAULAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHINCHINGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHULLAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHURUBAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COLPA BAJA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUACORA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUALLMISH</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANACAURE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCACHUPAC</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCAPALLAC</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCHAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">INGENIO BAJO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">JESUS DE NAZARETH DE COCHAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LA ESPERANZA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LAS MORAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LLACSA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MANANTIAL DE VIDA DE QUECHUALOMA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MARGOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NAUYAN RONDOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PACAYHUA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PAMPAS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PAUCAR</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PERU-COREA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PILLAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">POMACUCHO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">POTRACANCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUEBLO LIBRE DE MAYOBAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD DE LLICUA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD DE PACHABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD MALCONGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCO DE LLAMAPASHILLUM</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCOS DE COCHABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN ISIDRO DE PAURA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JOSE DE COZO TINGO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JUAN DE LIBERTAD</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN MIGUEL DE MITOQUERA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE CANI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE CHOQUECANCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE PILLAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN SEBASTIAN DE QUERA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA CRUZ DE RATACOCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ISABEL</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA MARIA DEL VALLE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA DE SIRABAMBA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTIAGO DE LLACON</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTO TORIBIO DE MOGROVEJO DE ARAYPAGU</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAMBO DE SAN JOSE</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAMBOGAN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAPRAG</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TRES DE MAYO DE ANDAS CHICO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TRES DE MAYO DE PAGSHAG</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">UTAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YACUS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YARUMAYO</th>';
            print'</tr>';
            print'</thead>';
            print '<tbody>';
            for ($i = 0; $i < count($report_red_huanuco); $i++) {
                print'<tr>';
                print'<td>' . ($i + 1) . '</td>';
                print'<td>' . $report_red_huanuco[$i]['cod_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['nom_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['a'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['b'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['c'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['d'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['e'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['f'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['g'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['h'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['i'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['j'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['k'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['l'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['m'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['n'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['o'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['p'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['q'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['s'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['t'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['u'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['v'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['w'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['xx'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['yy'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['z'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aa'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ab'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ac'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ad'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ae'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['af'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ag'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ah'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ai'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aj'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ak'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['al'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['am'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['an'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ao'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ap'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aq'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ar'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ass'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['att'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['au'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['av'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['aw'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ax'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ay'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['az'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['ba'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bb'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bc'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bd'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['be'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bf'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bg'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bh'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['bi'] . '</td>';
                print'</tr>';
            }
            print '<tbody>';
            print'</table>';
        } else if ($cod_red == '3') {
            $filename = 'red_salud_dos_mayo';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '4') {
            $filename = 'red_puerto_inca';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '5') {
            $filename = 'red_pachitea';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_red_huanuco = $this->bimestre_model->report_red_pachitea($fecha);
            print'<h2><strong>REPORTE DE STOCK A DIARIO - RED PACHITEA <strong></h2>';
            print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
            print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
            print'<thead>';
            print'<tr>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >CHAGLLA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >CHINCHAYCOCHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >GOYAR PUNTA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUACACHI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUARAPATAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUARICHACA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >JILLAULLA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MANZANO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MOLINOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MONTEHUASI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >MUÑA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PAMPAMARCA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PANAO</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PINQUIRAY</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PUCAJAGA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PUESTO DE SALUD HUANIN</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >SAN MARCOS</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >SANTO TORIBIO DE LA PUNTA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TAMBILLO-UMARI</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TAYAGASHA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TOMAYRICA</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >USHUMAYO</th>';
            print'</tr>';
            print'</thead>';
            print '<tbody>';
            for ($i = 0; $i < count($report_red_huanuco); $i++) {
                print'<tr>';
                print'<td>' . ($i + 1) . '</td>';
                print'<td>' . $report_red_huanuco[$i]['cod_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['nom_med'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['a'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['b'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['c'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['d'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['e'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['f'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['g'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['h'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['i'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['j'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['k'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['l'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['m'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['n'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['o'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['p'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['q'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['s'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['r'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['t'] . '</td>';
                print'<td>' . $report_red_huanuco[$i]['u'] . '</td>';
                print'</tr>';
            }
            print '<tbody>';
            print'</table>';
        } else if ($cod_red == '6') {
            $filename = 'red_huamalies';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        } else if ($cod_red == '7') {
            $filename = 'red_leoncio_prado';
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
        }
    }
    
    function view_report_ipress() {
        $list_fech_actual = $this->bimestre_model->fecha_actual2();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }
        $data['content'] = 'report_ipress_date';
        $data["fech_actual"] = $fech_actual;
        $this->load->view('template', $data);
    }

    function report_ipres_date_excel() {
        //$fecha = '2020-05-30';
        $fecha = $_REQUEST['fecha'];
        $idusuario = $this->session->userdata("usuario");
        $nom_ipres = $this->session->userdata("nom_ipres");
        $filename = 'IPRES_' . $idusuario . '_' . $nom_ipres;
        header("Pragma: public");
        header("Expies: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Content-Type application/force-download");
        header("Content-Type application/octet-stream");
        header("Content-Type application/download");
        header("Content-Type application/vnd.ms-excel;");
        header("Content-Disposition: attachment; filename=" . $filename . '.xls');
        print "\xEF\xBB\xBF"; // UTF-8 BOM
        $report_ipres = $this->bimestre_model->report_ipres_date($idusuario, $fecha);
        $row = count($report_ipres);
        if ($row > 0) {
            print'<h2><strong>REPORTE DE STOCK A DIARIO IPRESS - ' . $nom_ipres . '<strong></h2>';
            print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
            print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
            print'<thead>';
            print'<tr>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="40">Nº</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="75">Código</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
            print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="100">Stock</th>';
            print'</tr>';
            print'</thead>';
            print '<tbody>';
            for ($i = 0; $i < count($report_ipres); $i++) {
                print'<tr>';
                print'<td align="center" >' . ($i + 1) . '</td>';
                print'<td align="center" >' . $report_ipres[$i]['cod_med'] . '</td>';
                print'<td>' . $report_ipres[$i]['nom_med'] . '</td>';
                print'<td align="center" >' . $report_ipres[$i]['stock'] . '</td>';
                print'</tr>';
            }
            print '<tbody>';
            print'</table>';
        } else {
            $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
            redirect('principal/view_report_ipress');
        }
    }
    
    function view_report_sub_almacen() {
        $list_fech_actual = $this->bimestre_model->fecha_actual2();
        $fech_actual = '';
        for ($i = 0; $i < count($list_fech_actual); $i++) {
            $fech_actual = $list_fech_actual[$i]['fecha_actual'];
        }
        $data['content'] = 'report_sub_almacen_ipress';
        $data["fech_actual"] = $fech_actual;
        $this->load->view('template', $data);
    }

    function report_excel_sub_almacen() {
        //$fecha = '2020-05-30';
        $fecha = $_REQUEST['fecha'];
        $idusuario = $this->session->userdata("usuario");
        $nom_ipres = $this->session->userdata("nom_ipres");
        $filename = 'SUB-ALMACEN_' . $idusuario . '_' . $nom_ipres;

        if ($idusuario == '014S01') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_pachas($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD DOS DE MAYO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >LA UNION</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SILLAPATA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">VISTA ALEGRE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RACUAY</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SHUNQUI</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YANAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">QUIVILLA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MARIAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCAN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHUQUIS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TINGO CHICO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PICHGAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN PACHAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">UCRUMARCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">BELLAVISTA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">IRMA CHICO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COCHAPATA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN LORENZO DE ISCO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">GOLLUMYA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MAYNAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COCHABAMBA</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['l'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['m'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['n'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['o'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['p'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['q'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['r'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['s'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['t'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['u'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S02') {
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_leoncio_prado($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD LEONCIO PRADO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >CASTILLO GRANDE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">BELLA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">VENENILLO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD NARANJILLO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUPTE SAN JORGE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TOPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA DE SHAPAJILLA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MARONA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PABLO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUASCAR</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">BOLAYNA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ALTO SAN JUAN DE TULUMAYO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUMAHUASI</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD HERMILIO VALDIZAN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RIO AZUL</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN ISIDRO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RICARDO PALMA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ALTO PENDENCIA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE HUAYHUANTE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">AUCAYACU</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ANDA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUEBLO NUEVO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVA ASPUZANA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LAS MERCEDES</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUCAYACU</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TUPAC AMARU</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COTOMONILLO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LA MORADA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CRISNEJAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YANAJANCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PARAISO ( MEGOTE)</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MONZON</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">AGUA BLANCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CACHICOTO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CASHAPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MANCHURIA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PALO DE ACERO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CAUNARAPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SACHAVACA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CAYUMBA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LAS PALMAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAMBILLO GRANDE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUENTE PEREZ</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHINCHAVITO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUENTE DURAND</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LEONCIO PRADO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TAZO GRANDE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SORTILEGIO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CUYACU</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CONSUELO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN AGUSTIN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ALTO HUAYHUANTE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ANTONIO RAIMONDI</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JOSE DE PUCATE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVO JAEN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA DE ALTO YANAJANCA</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['l'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['m'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['n'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['o'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['p'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['q'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['r'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['s'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['t'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['u'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['v'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['w'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['xx'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['yy'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['z'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['aa'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ab'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ac'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ad'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ae'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['af'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ag'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ah'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ai'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['aj'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ak'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['al'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['am'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['an'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ao'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ap'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['aq'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ar'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ass'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['att'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['au'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['av'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['aw'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ax'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ay'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['az'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ba'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['bb'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['bc'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['bd'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S03') {
            
        } else if ($idusuario == '014S04') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_puerto_inca($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD PUERTO INCA <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >PUERTO INCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUERTO SUNGARO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NAVIDAD</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVO PORVENIR</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MACUYA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SHEBONYA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVA JERUSALEN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CLEYTON</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUERTO SIRA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YUYAPICHIS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">DANTAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">STA. ROSA DE YANAYACU</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN PUERTO INCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MONTERRICO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">EL DORADO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">GUACAMAYO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVO TRUJILLO</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['l'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['m'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['n'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['o'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['p'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['q'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S05') {
            
        } else if ($idusuario == '014S06') {
            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_huacrachuco($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD LEONCIO PRADO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUACRACHUCO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN BUENAVENTURA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD PISO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUARIPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE CHOCOBAMBA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHINCHIL</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUACHUMAY</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">VILLAMAR</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUAYCHAO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">FRAILE RUMI</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANPEDRO DE CHOLON</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN HUACRACHUCO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUANCHAY</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD DE GRANADILLA</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['l'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['m'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['n'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S07') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_ambo($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD AMBO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >AMBO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COCHAPATA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHAUCHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CONCHAMARCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">??AUZA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SACSAHUANCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TOMAYKICHUA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MARAYPATA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUACAR</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ANGASMARCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CAYNA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COLPAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MOSCATUNA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JUAN DE UTCUSH</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">YAPAC</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN PEDRO DE ACOBAMBA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN RAFAEL</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">AYANCOCHA ALTA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">COCHACALLA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHACOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">MATIHUACA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">TRES DE MAYO DE RODEO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCO DE MOSCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">STO. DOMINGO DE RONDOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN AMBO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ALCAS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CORRALCANCHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">QUIO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN FRANCISCO DE ACOCHACAN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ANA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SALAPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN ANTONIO DE CHUCCHUC</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ACOBAMBA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">EQUIPO AISPED RUTA AYANCOCHA ALTA- ACO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LA LIBERTAD</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['l'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['m'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['n'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['o'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['p'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['q'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['r'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['s'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['t'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['u'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['v'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['w'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['xx'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['yy'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['z'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['aa'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ab'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ac'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ad'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ae'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['af'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ag'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ah'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['ai'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S08') {
            
        } else if ($idusuario == '014S09') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_tornavista($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD PUERTO INCA <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >TOURNAVISTA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVA HONORIA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ANTIGUA HONORIA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SEMUYA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PRINCIPE DE PAZ</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD PROGRESO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SEÑOR DE LOS MILAGROS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">UNION PORVENIR</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN TOURNAVISTA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">DOS UNIDOS</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S10') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_codo_pozuzo($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD PUERTO INCA <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >C.S. CODO DEL POZUZO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA MARTHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN JUAN DE CODO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CHORROPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVA ESPERANZA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">AGUA BLANCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUAMPOMAYO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN CODO DEL POZUZO</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">NUEVO HORIZONTE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">LOS ANGELES</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
            
        } else if ($idusuario == '014S12') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_banios($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD DOS DE MAYO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >HUARIN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">CARAMARCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">BAÑOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">QUEROPALCA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN BAÑOS</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S13') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_rondos($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD DOS DE MAYO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >COSMA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">RONDOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PILCOCANCHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ISCOPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SECCHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PATAY RONDOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN RONDOS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">WARIWAYIN</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUARACAYOG</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SANTA ROSA DE PATOPAMPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">HUACARCOCHA</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['h'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['i'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['j'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['k'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        } else if ($idusuario == '014S14') {

            header("Pragma: public");
            header("Expies: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type application/force-download");
            header("Content-Type application/octet-stream");
            header("Content-Type application/download");
            header("Content-Type application/vnd.ms-excel;");
            header("Content-Disposition: attachment; filename=" . $filename . '.xls');
            print "\xEF\xBB\xBF"; // UTF-8 BOM
            $report_sub_almacen = $this->bimestre_model->report_sub_almacen_jesus($fecha);
            $row = count($report_sub_almacen);
            if ($row > 0) {
                print'<h2><strong>REPORTE DE STOCK GENERAL DEL SUB ALMACEN ' . $nom_ipres . ' - RED DE SALUD DOS DE MAYO <strong></h2>';
                print'<h4><strong>FECHA : ' . $fecha . ' <strong></h4>';
                print'<table class="table table-striped table-bordered table-hover" id="dataTables-example">';
                print'<thead>';
                print'<tr>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Nº</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">Código</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" width="495" height="30">Producto</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;" >C.S. JESUS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SAN MIGUEL DE CAURI</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD PARACSHA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">PUESTO DE SALUD SAN JUAN DE NUPE</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">SUB ALMACEN LAURICOCHA - JESUS</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">ANTACOLPA</th>';
                print'<th style="border:1px #888 solid;background-color:#00CCCC;color:white;">AISPED JESUS - CAURI</th>';
                print'</tr>';
                print'</thead>';
                print '<tbody>';
                for ($i = 0; $i < count($report_sub_almacen); $i++) {
                    print'<tr>';
                    print'<td align="center">' . ($i + 1) . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['cod_med'] . '</td>';
                    print'<td >' . $report_sub_almacen[$i]['nom_med'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['a'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['b'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['c'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['d'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['e'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['f'] . '</td>';
                    print'<td align="center">' . $report_sub_almacen[$i]['g'] . '</td>';
                    print'</tr>';
                }
                print '<tbody>';
                print'</table>';
            } else {
                $this->session->set_flashdata("mensaje", "No se encontro registro de stock con la fecha : " . $fecha);
                redirect('principal/view_report_sub_almacen');
            }
        }
    }
    
    

}
