<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bimestre_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    function list_bimetres($tip_med) {
        $sql = "SELECT p.cod_med,p.nom_med,tp.tip_med,tp.nom_tipo FROM producto p 
                INNER JOIN tipo_producto tp ON tp.tip_med=p.tip_med
                WHERE tp.tip_med='$tip_med'
                ORDER BY p.nom_med";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function list_bimetres2($tip_ipres) {
        $sql = "SELECT d.id_detalle,p.cod_med, p.nom_med,d.stock,DATE_FORMAT(fecha_reg,'%d/%m/%y') AS fecha FROM producto p 
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                WHERE d.cod_ipres='$tip_ipres' AND DATE_FORMAT(fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY tip_med ASC, nom_med ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function validad_registro($cod_ipres, $cod_med, $fech_actual) {
        $sql = "SELECT d.cod_med,d.cod_ipres,DATE_FORMAT(d.fecha_reg,'%d/%m/%y') AS fecha FROM detalle d
                INNER JOIN ipress i ON i.cod_ipres=d.cod_ipres
                WHERE d.cod_ipres='$cod_ipres' AND d.cod_med='$cod_med' AND DATE_FORMAT(d.fecha_reg,'%d/%m/%y')='$fech_actual'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function buscar_dettalle($id_detalle) {
        $sql = "SELECT d.id_detalle,d.cod_med,d.stock,d.cod_ipres,p.nom_med FROM detalle d 
                INNER JOIN producto p ON p.cod_med=d.cod_med
                WHERE d.id_detalle='$id_detalle'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function edit_detalle($data, $id_det) {
        $this->db->trans_start();
        $data = array(
            'stock' => $data['stock']
        );

        $this->db->where('id_detalle', $id_det);
        $this->db->update('detalle', $data);
        $this->db->trans_complete();
    }

    function max_fecha_reg($cod_ipres) {
        $sql = "SELECT DATE_FORMAT(MAX(DISTINCT(DATE(d.fecha_reg))),'%d/%m/%y') AS fecha_max FROM detalle d
                WHERE d.cod_ipres='$cod_ipres'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function list_ipress_reg($cod_red, $fecha_actual) {
        /*
        $sql = "SELECT DISTINCT(i.cod_ipres)AS cod_ipres, i.nom_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                WHERE i.cod_red='$cod_red' AND DAY(d.fecha_reg)='$dia_atual'
                ORDER BY i.nom_ipres ASC";
         * 
         */
        $sql = "SELECT DISTINCT(i.cod_ipres)AS cod_ipres, i.nom_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres 
                WHERE i.cod_red='$cod_red' AND DATE_FORMAT(fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY i.nom_ipres ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
        
    function list_ipress_reg_total($cod_red) {
        $sql = "SELECT i.cod_ipres, i.nom_ipres FROM ipress i 
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE i.cod_red='$cod_red'
                ORDER BY i.nom_ipres ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function list_prod_reg($tip_ipres, $fecha_max) {
        $sql = "SELECT p.cod_med, p.nom_med,d.stock,DATE_FORMAT(fecha_reg,'%d/%m/%y') AS fecha FROM producto p 
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                WHERE d.cod_ipres='$tip_ipres' AND DATE_FORMAT(fecha_reg,'%d/%m/%y')='$fecha_max'
                ORDER BY tip_med ASC, nom_med ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function list_red() {
        $sql = "SELECT * FROM red r ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
     function cant_ipress_total($cod_red) {
        $sql = "SELECT COUNT(i.cod_ipres) AS cant_ipres FROM ipress i 
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE i.cod_red='$cod_red'
                ORDER BY i.nom_ipres ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function cant_ipress_reg($cod_red,$dia_atual) {
        $sql = "SELECT COUNT(DISTINCT(i.cod_ipres))AS cant_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                WHERE i.cod_red='$cod_red' AND DATE_FORMAT(fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY i.nom_ipres ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function fecha_actual() {
        $sql = "SELECT DATE_FORMAT(NOW(),'%d/%m/%y') AS fecha_actual FROM DUAL";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function fecha_actual2() {
        $sql = "SELECT DATE((NOW())) AS fecha_actual FROM DUAL";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function max_fecha_reg_red($cod_red) {
        $sql = "SELECT DATE_FORMAT(MAX(DISTINCT(DATE(d.fecha_reg))),'%d/%m/%y') AS fecha_max FROM detalle d
                INNER JOIN ipress i ON i.cod_ipres=d.cod_ipres
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE r.cod_red='$cod_red'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_all_epp($cod_red,$fecha_max) {
        $sql = "SELECT DISTINCT(p.cod_med) AS cod_med,p.nom_med,SUM(d.stock) AS stock FROM producto p
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                INNER JOIN ipress i ON i.cod_ipres=d.cod_ipres
                INNER JOIN tipo_producto t ON t.tip_med=p.tip_med
                WHERE DATE_FORMAT(fecha_reg,'%d/%m/%y')='$fecha_max' AND i.cod_red='$cod_red'
                GROUP BY t.tip_med,p.cod_med
                ORDER BY t.tip_med ASC,t.nom_tipo ASC,p.nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_detalle_reg($cod_ipres) {
        $sql = "SELECT p.cod_med,p.nom_med,d.stock FROM producto p 
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                WHERE d.cod_ipres='$cod_ipres' AND DATE_FORMAT(fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY p.tip_med ASC, p.nom_med ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

    function buscar_ipress($cod_ipres) {
        $sql = "SELECT * FROM ipress i
                WHERE i.cod_ipres='$cod_ipres'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_prod_stock_ant($cod_ipres) {
        $sql = "SELECT p.cod_med,p.nom_med,d.stock,d.cod_ipres,DATE_FORMAT(DATE(fecha_reg),'%d/%m/%y') AS fecha_reg FROM  producto p
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                INNER JOIN ipress i ON i.cod_ipres=d.cod_ipres
                INNER JOIN tipo_producto t ON t.tip_med=p.tip_med
                WHERE i.cod_ipres='$cod_ipres' AND DATE_FORMAT(fecha_reg,'%d/%m/%y') 
                IN (SELECT DATE_FORMAT(MAX(DISTINCT(DATE(d.fecha_reg))),'%d/%m/%y') AS fecha_max FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                WHERE i.cod_ipres='$cod_ipres')
                ORDER BY t.tip_med ASC, t.nom_tipo ASC, p.nom_med ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function buscar_cod_ipress($cod_ipres){
        $sql = "SELECT * FROM ipress i
                WHERE i.cod_ipres='$cod_ipres'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_subalmacen($cod_red){
        $sql = "SELECT DISTINCT(i.cod_ipres),i.nom_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE i.tipo_alm IS NOT NULL AND r.cod_red='$cod_red' AND  DATE_FORMAT(d.fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY i.nom_ipres ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
        
    }
    
    function list_unid_ejecutoras($cod_red){
        $sql = "SELECT DISTINCT(i.cod_ipres),i.nom_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE r.cod_red='$cod_red' AND DATE_FORMAT(d.fecha_reg,'%d/%m/%y')=DATE_FORMAT(NOW(),'%d/%m/%y')
                ORDER BY i.nom_ipres ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_all_ipress($cod_red){
        $sql = "SELECT DISTINCT(i.cod_ipres),i.nom_ipres FROM ipress i
                INNER JOIN detalle d ON d.cod_ipres=i.cod_ipres
                INNER JOIN red r ON r.cod_red=i.cod_red
                WHERE r.cod_red='$cod_red' AND DATE_FORMAT(d.fecha_reg,'%d/%m/%y')= DATE_FORMAT(NOW(),'%d/%m/%y')";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_red_byid($cod_red) {
        $sql = "SELECT * FROM red d WHERE d.cod_red='$cod_red'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function list_red_salud(){
        $sql = "SELECT i.cod_ipres,i.nom_ipres FROM ipress i
                WHERE i.cod_red='10'";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function reporte_red_salud($fecha){
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(red_ambo),0) AS red_ambo,
                COALESCE(SUM(red_huanuco),0) AS red_huanuco,
                COALESCE(SUM(red_dos_mayo),0) AS red_dos_mayo,
                COALESCE(SUM(red_puerto_inca),0) AS red_puerto_inca,
                COALESCE(SUM(red_pachitea),0) AS red_pachitea,
                COALESCE(SUM(red_huamalies),0) AS red_huamalies,
                COALESCE(SUM(red_leoncio_prado),0) AS red_leoncio_prado  
                FROM producto_red_salud
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
       function report_red_huanuco($fecha){
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q, 
                COALESCE(SUM(r),0) AS r,  
                COALESCE(SUM(s),0) AS s,  
                COALESCE(SUM(t),0) AS t,  
                COALESCE(SUM(u),0) AS u, 
                COALESCE(SUM(v),0) AS v,  
                COALESCE(SUM(w),0) AS w,  
                COALESCE(SUM(xx),0) AS xx,  
                COALESCE(SUM(yy),0) AS yy, 
                COALESCE(SUM(z),0) AS z,  
                COALESCE(SUM(aa),0) AS aa,  
                COALESCE(SUM(ab),0) AS ab,  
                COALESCE(SUM(ac),0) AS ac, 
                COALESCE(SUM(ad),0) AS ad,  
                COALESCE(SUM(ae),0) AS ae,  
                COALESCE(SUM(af),0) AS af,  
                COALESCE(SUM(ag),0) AS ag, 
                COALESCE(SUM(ah),0) AS ah,  
                COALESCE(SUM(ai),0) AS ai,  
                COALESCE(SUM(aj),0) AS aj,  
                COALESCE(SUM(ak),0) AS ak, 
                COALESCE(SUM(al),0) AS al, 
                COALESCE(SUM(am),0) AS am, 
                COALESCE(SUM(an),0) AS an, 
                COALESCE(SUM(ao),0) AS ao, 
                COALESCE(SUM(ap),0) AS ap, 
                COALESCE(SUM(aq),0) AS aq, 
                COALESCE(SUM(ar),0) AS ar, 
                COALESCE(SUM(ass),0) AS ass, 
                COALESCE(SUM(att),0) AS att,
                COALESCE(SUM(au),0) AS au,
                COALESCE(SUM(av),0) AS av,
                COALESCE(SUM(aw),0) AS aw,
                COALESCE(SUM(ax),0) AS ax,
                COALESCE(SUM(ay),0) AS ay,
                COALESCE(SUM(az),0) AS az,
                COALESCE(SUM(ba),0) AS ba,
                COALESCE(SUM(bb),0) AS bb,
                COALESCE(SUM(bc),0) AS bc,
                COALESCE(SUM(bd),0) AS bd,
                COALESCE(SUM(be),0) AS be,
                COALESCE(SUM(bf),0) AS bf,
                COALESCE(SUM(bg),0) AS bg,
                COALESCE(SUM(bh),0) AS bh,
                COALESCE(SUM(bi),0) AS bi
                FROM producto_red_huanuco
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_red_pachitea($fecha){
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q, 
                COALESCE(SUM(r),0) AS r,  
                COALESCE(SUM(s),0) AS s,  
                COALESCE(SUM(t),0) AS t,  
                COALESCE(SUM(u),0) AS u, 
                COALESCE(SUM(v),0) AS v  
                FROM producto_red_pachitea
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_leoncio_prado($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q, 
                COALESCE(SUM(r),0) AS r,  
                COALESCE(SUM(s),0) AS s,  
                COALESCE(SUM(t),0) AS t,  
                COALESCE(SUM(u),0) AS u, 
                COALESCE(SUM(v),0) AS v,  
                COALESCE(SUM(w),0) AS w,  
                COALESCE(SUM(xx),0) AS xx,  
                COALESCE(SUM(yy),0) AS yy, 
                COALESCE(SUM(z),0) AS z,  
                COALESCE(SUM(aa),0) AS aa,  
                COALESCE(SUM(ab),0) AS ab,  
                COALESCE(SUM(ac),0) AS ac, 
                COALESCE(SUM(ad),0) AS ad,  
                COALESCE(SUM(ae),0) AS ae,  
                COALESCE(SUM(af),0) AS af,  
                COALESCE(SUM(ag),0) AS ag, 
                COALESCE(SUM(ah),0) AS ah,  
                COALESCE(SUM(ai),0) AS ai,  
                COALESCE(SUM(aj),0) AS aj,  
                COALESCE(SUM(ak),0) AS ak, 
                COALESCE(SUM(al),0) AS al, 
                COALESCE(SUM(am),0) AS am, 
                COALESCE(SUM(an),0) AS an, 
                COALESCE(SUM(ao),0) AS ao, 
                COALESCE(SUM(ap),0) AS ap, 
                COALESCE(SUM(aq),0) AS aq, 
                COALESCE(SUM(ar),0) AS ar, 
                COALESCE(SUM(ass),0) AS ass, 
                COALESCE(SUM(att),0) AS att,
                COALESCE(SUM(au),0) AS au,
                COALESCE(SUM(av),0) AS av,
                COALESCE(SUM(aw),0) AS aw,
                COALESCE(SUM(ax),0) AS ax,
                COALESCE(SUM(ay),0) AS ay,
                COALESCE(SUM(az),0) AS az,
                COALESCE(SUM(ba),0) AS ba,
                COALESCE(SUM(bb),0) AS bb,
                COALESCE(SUM(bc),0) AS bc,
                COALESCE(SUM(bd),0) AS bd
                FROM producto_sub_alm_leoncio_prado
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_ambo($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q, 
                COALESCE(SUM(r),0) AS r,  
                COALESCE(SUM(s),0) AS s,  
                COALESCE(SUM(t),0) AS t,  
                COALESCE(SUM(u),0) AS u, 
                COALESCE(SUM(v),0) AS v,  
                COALESCE(SUM(w),0) AS w,  
                COALESCE(SUM(xx),0) AS xx,  
                COALESCE(SUM(yy),0) AS yy, 
                COALESCE(SUM(z),0) AS z,  
                COALESCE(SUM(aa),0) AS aa,  
                COALESCE(SUM(ab),0) AS ab,  
                COALESCE(SUM(ac),0) AS ac, 
                COALESCE(SUM(ad),0) AS ad,  
                COALESCE(SUM(ae),0) AS ae,  
                COALESCE(SUM(af),0) AS af,  
                COALESCE(SUM(ag),0) AS ag, 
                COALESCE(SUM(ah),0) AS ah,  
                COALESCE(SUM(ai),0) AS ai
                FROM producto_sub_alm_ambo
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_huacrachuco($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n
                FROM producto_sub_alm_huacrachuco
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_pachas($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q, 
                COALESCE(SUM(r),0) AS r,  
                COALESCE(SUM(s),0) AS s,  
                COALESCE(SUM(t),0) AS t,  
                COALESCE(SUM(u),0) AS u
                FROM producto_sub_alm_pachas
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_banios($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f   
                FROM producto_sub_alm_banios
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_rondos($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k  
                FROM producto_sub_alm_rondos
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_jesus($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g 
                FROM producto_sub_alm_jesus
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_puerto_inca($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j,
                COALESCE(SUM(k),0) AS k, 
                COALESCE(SUM(l),0) AS l, 
                COALESCE(SUM(m),0) AS m, 
                COALESCE(SUM(n),0) AS n,  
                COALESCE(SUM(o),0) AS o,  
                COALESCE(SUM(p),0) AS p,  
                COALESCE(SUM(q),0) AS q 
                FROM producto_sub_alm_puerto_inca
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_tornavista($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j
                FROM producto_sub_alm_tornavista
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_sub_almacen_codo_pozuzo($fecha) {
        $sql = "SELECT cod_med,nom_med,
                COALESCE(SUM(a),0) AS a, 
                COALESCE(SUM(b),0) AS b, 
                COALESCE(SUM(c),0) AS c, 
                COALESCE(SUM(d),0) AS d, 
                COALESCE(SUM(e),0) AS e, 
                COALESCE(SUM(f),0) AS f, 
                COALESCE(SUM(g),0) AS g, 
                COALESCE(SUM(h),0) AS h, 
                COALESCE(SUM(i),0) AS i, 
                COALESCE(SUM(j),0) AS j
                FROM producto_sub_alm_cod_pozuzo 
                WHERE DATE(fecha_reg)='$fecha'
                GROUP BY cod_med
                ORDER BY tip_med ASC, nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }
    
    function report_ipres_date($cod_ipres,$fecha) {
        $sql = "SELECT p.cod_med,p.nom_med,d.stock FROM producto p 
                INNER JOIN detalle d ON d.cod_med=p.cod_med
                WHERE d.cod_ipres='$cod_ipres' AND DATE(fecha_reg)='$fecha'
                ORDER BY p.tip_med, p.nom_med ASC ";
        $rs = $this->db->query($sql);
        $bimestres = $rs->result_array();
        return $bimestres;
    }

}
