<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Unidades_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    function list_unidades($idpersonal) {
        $sql = "SELECT u.idunidades,u.nom_unidad,u.icono,g.nom_grado,b.nom_bimestre,c.nom_contenido,u.archivo_unidad,u.fecha_registro FROM unidades u 
                INNER JOIN personal p ON p.idpersonal=u.idpersonal 
                INNER JOIN grado g ON g.idgrado=u.idgrado
                INNER JOIN bimestre b ON b.idbimestre=u.idbimestre
                INNER JOIN contenido c ON c.idcontenido = u.idcontenido
                WHERE u.idpersonal='$idpersonal'";
        $rs = $this->db->query($sql);
        $unidades = $rs->result_array();
        return $unidades;
    }
    
    function list_unidades_by_id($idpersonal,$idbimestre,$idgrado) {
        $sql = "SELECT u.idunidades,pe.nombre,pe.apellidos,u.nom_unidad,u.fecha_registro,u.archivo_unidad,u.icono,u.n_sesiones,g.nom_grado,u.estado FROM unidades u 
                INNER JOIN grado g ON g.idgrado=u.idgrado
                INNER JOIN personal p ON p.idpersonal=u.idpersonal
                INNER JOIN persona pe ON pe.idpersona=p.idpersona
                WHERE p.idpersonal='$idpersonal' AND u.idbimestre='$idbimestre' AND u.idgrado='$idgrado'";
        $rs = $this->db->query($sql);
        $unidades = $rs->result_array();
        return $unidades;
    }

    function id_personal($idusuario) {
        $sql = "SELECT pe.idpersonal AS id_personal FROM personal pe 
                INNER JOIN persona p ON pe.idpersona=p.idpersona
                WHERE p.dni='$idusuario'";
        $rs = $this->db->query($sql);
        $personal = $rs->result_array();
        return $personal;
    }

    function max_id_unidades() {
        $sql = "SELECT MAX(idunidades) + 1 AS id_unidades FROM unidades";
        $rs = $this->db->query($sql);
        $unidades = $rs->result_array();
        return $unidades;
    }

    function add_unidadad($data) {
        $this->db->trans_start();
        $this->db->insert('detalle', array(
            'cod_med' => $data['cod_med'],
            'stock' => $data['stock'],
            'cod_ipres' => $data['cod_ipres']
        ));
        $this->db->trans_complete();
    }

    function elim_unidad($idunidad) {
        $this->db->where('idunidades', $idunidad);
        $this->db->delete('unidades');
    }

    function buscar_archivo($idusuario) {
        $sql = "SELECT u.archivo_unidad FROM unidades u
                INNER JOIN personal p ON p.idpersonal=u.idpersonal
                INNER JOIN persona pe ON pe.idpersona=p.idpersona
                WHERE pe.dni='$idusuario'";
        $rs = $this->db->query($sql);
        $unidades = $rs->result_array();
        return $unidades;
    }

    function validad_cat_unid($idusuario,$idbimestre,$idgrado) {
        $sql = "SELECT COUNT(u.idunidades) AS cant_unidades FROM unidades u 
                INNER JOIN bimestre b ON b.idbimestre=u.idbimestre
                INNER JOIN personal p ON p.idpersonal=u.idpersonal
                INNER JOIN persona pe ON pe.idpersona=p.idpersona
                INNER JOIN grado g ON g.idgrado=u.idgrado
                WHERE pe.dni='$idusuario' AND b.idbimestre='$idbimestre' AND g.idgrado='$idgrado'
                GROUP BY b.idbimestre";
        $rs = $this->db->query($sql);
        $unidades = $rs->result_array();
        return $unidades;
    }

}
